<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MainController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/',[MainController::class,"index"])->name("index");
Route::get('/product/{slug}',[MainController::class,"productDetail"])->name("product.detail");
Route::get('/search',[MainController::class,"productSearch"])->name("product.search");
Route::get('/category/{slug}',[MainController::class,"category"])->name("category");
Route::get('/tools',[MainController::class,"tools"])->name("tool");



Route::group(['prefix' => 'admin-panel'], function () {
    Voyager::routes();
});
