<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>Heroic Features - Start Bootstrap Template</title>
        <!-- Favicon-->
        <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
        <!-- Bootstrap icons-->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet" />
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="{{asset('frontend/css/styles.css')}}" rel="stylesheet" />
    </head>
    <body>
		<nav class="navbar navbar-expand-lg bg-body-light navbar-light">
  <div class="container px-5">
    <a class="navbar-brand" href="{{route('index')}}">Navbar</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarSupportedContent">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link  {{Route::is('index')?'active':'' }}" aria-current="page" href="{{route('index')}}">Home</a>
        </li>
		@php
		$header_categories = TCG\Voyager\Models\Category::whereParentId(null)->get();
		@endphp
		@foreach($header_categories as $data)
		   <li class="nav-item">
          <a class="nav-link {{Route::is('category') && request()->slug == $data->slug ? 'active' : ''}}" aria-current="page" href="{{route('category',$data->slug)}}">{{$data->name}}</a>
        </li>
		@endforeach
        
        
        
      </ul>
      <form class="d-flex" role="search" action="{{route('product.search')}}" method="get">		  
		  <div class="input-group mb-3">
  		<select class="btn btn-outline-dark dropdown-toggle" name="category">
			  @php
						$header_categories = TCG\Voyager\Models\Category::whereParentId(null)->get();
						@endphp
						@foreach($header_categories as $data)
                        <option value="{{$data->slug}}">
							{{$data->name}}
						</option>
						@endforeach
          
		 </select>
  <input class="form-control" type="search" name="search" placeholder="Search Any Product Name" aria-label="Search">
			  <button class="btn btn-outline-success" type="submit">Search</button>
</div>

        
        
      </form>
    </div>
  </div>
</nav>
        
		
		@yield("content")

<!-- Footer-->
        <footer class="py-5 bg-dark">
            <div class="container"><p class="m-0 text-center text-white">Copyright &copy; Your Website 2023</p></div>
        </footer>
        <!-- Bootstrap core JS-->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
        <!-- Core theme JS-->
        <script src="{{asset('frontend/js/scripts.js')}}"></script>
    </body>
</html>