<?php

namespace App\Http\Controllers;
use TCG\Voyager\Models\Category;
use App\Product;
use Illuminate\Http\Request;

class MainController extends Controller
{
    public function index(){
	$data = [];
	$data["categories"] = Category::whereParentId(null)->get();
	return view("index",$data);
	}
	
	public function category($slug){
	$data = [];
	$data["category"] = Category::whereParentId(null)->whereSlug($slug)->first();
		if($data["category"]==null){
		return redirect()->route("category");
		}
	return view("category",$data);
	}
	
	public function productSearch(Request $request){
	$data = [];
	$category = Category::whereParentId(null)->whereSlug($request->category)->first();
		if($category==null){
		return redirect()->route("index");
		}
	$data["product"] = Product::where('name',"like","%".$request->search."%")->whereCategoryId($category->id)->whereStatus(true)->get();
		if($data["product"]==null){
		return redirect()->route("index");
		}
	return view("product_search",$data);
	}
	
	public function productDetail($slug){
	$data = [];
	$data["product"] = Product::whereSlug($slug)->whereStatus(true)->first();
		if($data["product"]==null){
		return redirect()->route("index");
		}
	$data["related_products"] = Product::whereCategoryId($data["product"]->category_id)->whereStatus(true)->get();
	$data["categories"] = Category::whereParentId(null)->get();
	return view("product_detail",$data);
	}
	
	public function tools(){
	return view("tools");
	}
}
